<?php
/**
 * crypto_icon_lite Theme Customizer
 *
 * @package Crypto Icon Lite
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

//////////////////////////////////////////////////////////////////
// Customizer - Add CSS
//////////////////////////////////////////////////////////////////
function crypto_icon_lite_customizer_css() {
    ?>
    <style type="text/css">
        .posts-heading h3 { background-color:<?php echo esc_attr(get_theme_mod( 'crypto_icon_lite_breakingnews_bg' )); ?>; }
        .posts-heading h3::after {     
            content: '';
            width: 0;
            height: 0;
            border-style: solid;
            border-width: 38px 0 0px 25px;
            border-color: transparent transparent transparent #f2a900;
            line-height: 0px;
            _border-color: #000000 #000000 #000000 #ffa01c;
            _filter: progid:DXImageTransform.Microsoft.Chroma(color='#000000');
            display: inline-block;
            position: absolute;
            right: -25px;
            border-color:<?php echo esc_attr(get_theme_mod( 'crypto_icon_lite_breakingnews_bg' )); ?>; }
        h3.first-section-heading { color:<?php echo esc_attr(get_theme_mod( 'crypto_icon_lite_first_section_heading_color' )); ?>; }
        p.first-section-paragraph { color:<?php echo esc_attr(get_theme_mod( 'crypto_icon_lite_first_section_paragraph_color' )); ?>; }
        footer.top a { color:<?php echo esc_attr(get_theme_mod( 'crypto_icon_lite_first_section_button_color' )); ?>; }
        footer.top a { border-color:<?php echo esc_attr(get_theme_mod( 'crypto_icon_lite_first_section_button_color' )); ?>; }
    </style>
    <?php
}
add_action( 'wp_head', 'crypto_icon_lite_customizer_css' );

if ( !class_exists( '\WP_Customize_Control' ) ) {
    return null;
}

include( get_template_directory() . '/inc/class-customizer-toggle-control.php' );
include( get_template_directory() . '/inc/class-customizer-posts-dropdown-control.php' );

function crypto_icon_lite_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
    

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'crypto_icon_lite_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'crypto_icon_lite_customize_partial_blogdescription',
		) );
	}

	$wp_customize->add_section( 'crypto_icon_lite_misc_settings', array(
        'title'          => esc_html__( 'Theme Settings', 'crypto-icon-lite' ),
        'priority'       => 106,
    ) );

    $wp_customize->add_section( 'crypto_icon_lite_slider_settings', array(
    	'title'			=> esc_html__( 'Theme Slider', 'crypto-icon-lite' ),
    	'description'	=> esc_html__( 'Edit Slider below Main Menu', 'crypto-icon-lite' ),
    	'priority'		=> 105,
    ) );
 
    $wp_customize->add_setting( 'footer_credit_text', array(
        'default'        	=> 'Theme Icon',
        'sanitize_callback'	=> 'sanitize_text_field',
        'transport'         => 'postMessage',
    ) );

    $wp_customize->add_setting( 'footer_credit_text_link', array(
        'default'           => 'https://themeicon.com/',
        'sanitize_callback'	=> 'esc_url_raw',
        'transport'         => 'postMessage',
    ) );

    $wp_customize->add_setting( 'crypto_icon_lite_breaking_news', array(
        'default'           => '',
        'sanitize_callback' => 'crypto_icon_lite_sanitize_checkbox',
    ) );

    $wp_customize->add_control( new Crypto_Customizer_Toggle_Control( $wp_customize, 'crypto_icon_lite_breaking_news', array(
        'label'       => esc_html__( 'Display Breaking News?', 'crypto-icon-lite' ),
        'description' => esc_html__( 'Show or Hide Breaking News section', 'crypto-icon-lite' ),
        'section'     => 'crypto_icon_lite_misc_settings',
        'settings'    => 'crypto_icon_lite_breaking_news',
        'type'        => 'light',
    ) ) );

    $wp_customize->add_control( 'footer_credit_text', array(
        'label'   => esc_html__( 'Footer Credit Text', 'crypto-icon-lite' ),
        'section' => 'crypto_icon_lite_misc_settings',
        'type'    => 'text',
    ) );

    $wp_customize->add_control( 'footer_credit_text_link', array(
    	'label'		=> esc_html__( 'Footer Credit Text URL', 'crypto-icon-lite' ),
    	'section'	=> 'crypto_icon_lite_misc_settings',
    	'type'		=> 'url'
    ) );
 
 	$wp_customize->add_setting( 'crypto_icon_lite_slider_show', array(
        'default'        	=> '',
        'sanitize_callback'	=> 'crypto_icon_lite_sanitize_checkbox',
    ) );

    $wp_customize->add_setting( 'crypto_icon_lite_slides', array(
        'default'           => '',
        'sanitize_callback' => 'absint',
    ) );

    $wp_customize->add_control( new Crypto_Customizer_Toggle_Control( $wp_customize, 'crypto_icon_lite_slider_toggle', array(
        'label'       => esc_html__( 'Show Slider?', 'crypto-icon-lite' ),
        'description' => esc_html__( 'Slider will display below main menu', 'crypto-icon-lite' ),
        'section'     => 'crypto_icon_lite_slider_settings',
        'settings'    => 'crypto_icon_lite_slider_show',
        'type'        => 'light',
    ) ) );

    $wp_customize->add_control( new Crypto_Category_Control( $wp_customize, 'crypto_icon_lite_slides_content', array(
        'label'             => esc_html__( 'Choose posts for slides', 'crypto-icon-lite' ),
        'section'           => 'crypto_icon_lite_slider_settings',
        'settings'          => 'crypto_icon_lite_slides',
        'type'              => 'select',
    ) ) );

    // Sanitize callback
    function crypto_icon_lite_sanitize_checkbox( $input ){
        return ( ( isset( $input ) && true == $input ) ? true : false );
    }

    // Sannitize radio type
    function crypto_icon_lite_sanitize_radio( $input ) {
        $valid = array(
            'header_classic' => __( 'Classic Header', 'crypto-icon-lite' ),
            'header_center' => __( 'Center Header', 'crypto-icon-lite' ),
        );

        if ( array_key_exists( $input, $valid ) ) {
            return $input;
        }

        return '';
    }

}
add_action( 'customize_register', 'crypto_icon_lite_customize_register' );


/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function crypto_icon_lite_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function crypto_icon_lite_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function crypto_icon_lite_customize_preview_js() {
	wp_enqueue_script( 'crypto_icon_lite-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '250418', true );
}
add_action( 'customize_preview_init', 'crypto_icon_lite_customize_preview_js' );

