<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Crypto Icon Lite
 */

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?> itemscope itemtype="http://schema.org/WebPage">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>


<?php
$crypto_icon_lite_header_style = 'header_center';
?>

<body <?php body_class($crypto_icon_lite_header_style); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'crypto-icon-lite' ); ?></a>
		<?php $crypto_icon_lite_breakingnews_toggle = get_theme_mod( 'crypto_icon_lite_breaking_news' );
	if ( ! empty( $crypto_icon_lite_breakingnews_toggle ) ) {
		if ( is_home() || is_front_page() ) {
				echo "<div class='posts-heading'><h3 class='col-lg-2 col-md-3 col-sm-12 col-xs-12'>" . esc_html__( 'Breaking News', 'crypto-icon-lite' ) . "</h3>"; ?>
					<div class="breakingnews-list col-lg-10 col-md-9 col-sm-12 col-xs-12">
					<?php
					// WP_Query arguments
					$args = array(
						'post_type'     => array( 'post' ),
						'post_status'   => array( 'publish' ),
						'tag'			=> array( 'breakingnews' ),
						'orderby'		=> 'date',
						'no_found_rows' => true,
						'update_post_meta_cache' => false,
						'update_post_term_cache' => false,
						'fields'				=> 'ids',
					);

					// The Query
					$breakingnews = new WP_Query( $args );

					// The Loop
					if ( $breakingnews->have_posts() ) { 
						while ( $breakingnews->have_posts() ) {
							$breakingnews->the_post(); ?>
							<a class="breaking-title" href="<?php esc_url( the_permalink() ); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
					<?php } 
					} else {
						echo '<p>'.esc_html__( 'Posts with tagged "breakingnews" will show up here!', 'crypto-icon-lite' ).'</p>';
					}

					// Restore original Post Data
					wp_reset_postdata(); ?>

					<?php echo "</div></div>"; // end .posts-heading
	} } ?>
		<?php
		if( 'header_classic' === $crypto_icon_lite_header_style ) {
			get_template_part( 'template-parts/header', 'classic' );
		}
		elseif( 'header_center' === $crypto_icon_lite_header_style ) {
			get_template_part( 'template-parts/header', 'center' );
		}
		?>

	<div id="content" class="site-content container">
	
			<?php
			if ( function_exists('yoast_breadcrumb') && !is_home() ) {
			yoast_breadcrumb('
			<div id="breadcrumbs">','</div>
			');
			}
			?>
		<?php //support Yoast SEO breadcrumb ?>
		<div class="row">
