<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Crypto Icon Lite
 */

?>




<article id="post-<?php the_ID(); ?>" <?php post_class( 'row' ); ?>>
	<figure class="entry-thumbnail col-lg-4 col-md-4 col-sm-12 col-12">
		<?php if( has_post_thumbnail() && false == is_singular() ) {
			the_post_thumbnail( '' );	
		} else {
			echo '<img alt="no thumbnail" src="'. get_template_directory_uri() . '/images/no-thumbnail.jpg'.'">';
		}

		 ?>
	</figure>
	<div class="entry-summary col-lg-8 col-md-8 col-sm-12 col-12">
		<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php crypto_icon_lite_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			the_excerpt( sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'crypto-icon-lite' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				get_the_title()
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'crypto-icon-lite' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->
	<?php if( is_single() ) { ?>
		<footer class="entry-footer">
		<?php crypto_icon_lite_entry_footer(); ?>
		</footer><!-- .entry-footer -->
	<?php } ?>
	
	</div><!--/ .entry-summary-->
	<hr class="hline">
</article><!-- #post-<?php the_ID(); ?> -->

